import Vue from 'vue'
import VueRouter from 'vue-router'
Vue.use(VueRouter)

const files = require.context('./', true, /\.vue$/i)
files.keys().map(key => Vue.component(key.split('/').pop().split('.')[0], files(key).default))

import Index from './components/Index'
import Search from './components/Search'
import Board from './components/Board'
import Create from './components/Create'
import Thread from './components/Thread'

const routes = [
  { path: '/forums', component: Index, meta: {title: 'forums'} },
  { path: '/forums/search', name: 'search', component: Search, meta: {title: 'search'} },
  { path: '/forums/boards/:bid', name: 'board', component: Board, meta: {title: 'board'} },
  { path: '/forums/boards/:bid/page/:page', name: 'board_page', component: Board, meta: {title: 'board'} },
  { path: '/forums/create/:bid', component: Create, meta: {title: 'create'} },
  { path: '/forums/threads/:tid', name: 'thread', component: Thread, meta: {title: 'thread'} },
  { path: '/forums/threads/:tid/page/:page', name: 'thread_page', component: Thread, meta: {title: 'thread'}}
]

const router = new VueRouter({
  routes,
  mode: 'history'
})

router.beforeEach((to, from, next) => {
  document.title = Vue.options.filters.lang(to.meta.title) + titleSuffix
  next()
})

const forumsspa = new Vue({
  el: '#forumsspa',
  router
})
