<?php
use \App\Middleware\AuthMiddleware;
use \App\Middleware\AdminMiddleware;
use \Forums\Middleware\CanViewMiddleware;
use \Forums\Middleware\CanModerateMiddleware;
use \Forums\Middleware\ThreadUnlockedMiddleware;

$app->group('/admin/forums', function($group) {
    $group->get('', 'ForumsPageController:admin')->setName('admin_forums');
    $group->post('/category', 'ForumsAdminController:postCategory');
    $group->delete('/category', 'ForumsAdminController:deleteCategory');
    $group->post('/board', 'ForumsAdminController:postBoard');
    $group->delete('/board', 'ForumsAdminController:deleteBoard');
    $group->post('/updateboardpositions', 'ForumsAdminController:postUpdateBoardPositions');
    $group->get('/permissions', 'ForumsAdminController:getPermissions');
    $group->post('/permissions', 'ForumsAdminController:postPermissions');
})->add(new AdminMiddleware($container));

$app->group('/forums', function($group) use ($container) {
    $group->get('', 'ForumsPageController:spa')->setName('forums');
    $group->get('/search', 'ForumsPageController:spa');
    $group->get('/posts/{pid}', 'ForumsPageController:post')->setName('post');
    $group->get('/boards/{bid}[/page/{page}]', 'ForumsPageController:spa')->add(new CanViewMiddleware($container))->setName('board');
    $group->get('/create/{bid}', 'ForumsPageController:spa')->add(new CanViewMiddleware($container))->setName('create');
    $group->get('/threads/{tid}[/page/{page}]', 'ForumsPageController:spa')->add(new CanViewMiddleware($container))->setName('thread');

    $group->group('/api', function($group) use ($container) {
        $group->get('/index', 'ForumsApiController:getIndex');
        $group->get('/search', 'ForumsApiController:getSearch');
        $group->get('/posts/{pid}', 'ForumsApiController:getPost');
        $group->get('/boards/{bid}[/page/{page}]', 'ForumsApiController:getBoard')->add(new CanViewMiddleware($container));
        $group->get('/threads/{tid}[/page/{page}]', 'ForumsApiController:getThread')->add(new CanViewMiddleware($container));
    });
});

$app->group('/forums', function($group) use ($container) {
    $group->post('/create', 'ForumsApiController:create');
    $group->post('/reply', 'ForumsApiController:reply')->add(new ThreadUnlockedMiddleware($container));
    $group->post('/edit', 'ForumsApiController:edit')->add(new ThreadUnlockedMiddleware($container));
    $group->patch('/threads/{tid}', 'ForumsApiController:patchThread')->add(new ThreadUnlockedMiddleware($container));
    $group->delete('/delete', 'ForumsApiController:delete');
    $group->post('/mentionAutoComplete', 'ForumsApiController:mentionAutoComplete');
    $group->post('/react', 'ForumsApiController:react')->add(new ThreadUnlockedMiddleware($container));
    $group->post('/toggleThreadState', 'ForumsApiController:toggleThreadState')->add(new CanModerateMiddleware($container));
    $group->post('/moveThread', 'ForumsApiController:moveThread')->add(new CanModerateMiddleware($container));
})->add(new AuthMiddleware($container));
