<?php
namespace Forums\Models;

use App\Models\Model;

class ForumThread extends Model
{
    protected $primaryKey = 'tid';
    public $timestamps = false;
    protected $guarded = [];

    public function posts() {
        return $this->hasMany('Forums\Models\ForumPost', 'tid', 'tid');
    }

    public function latest_post() {
        return $this->hasOne('Forums\Models\ForumPost', 'tid', 'tid')->orderBy('timestamp','DESC');
    }

    public function first_post() {
        return $this->hasOne('Forums\Models\ForumPost', 'tid', 'tid')->orderBy('timestamp','ASC');
    }

    public function user() {
        return $this->belongsTo(ForumUser::class);
    }

    public function board() {
        return $this->belongsTo('Forums\Models\ForumBoard', 'bid', 'bid');
    }

    public function getReadTimestampAttribute() {
      return $this->read_timestamp_relation->timestamp ?? null;
    }

    public function read_timestamp_relation() {
        global $container;
        return $this->hasOne(ForumThreadsRead::class, 'tid', 'tid')->where('user_id', $container->auth->id() ?? null);
    }
}
