<?php
namespace Forums\Models;
use App\Models\Model;

class ForumCategory extends Model
{
    protected $primaryKey = 'cid';
    public $timestamps = false;
    protected $guarded = [];
    protected $with = ['permissions'];

    public function boards() {
        return $this->hasMany('Forums\Models\ForumBoard', 'cid', 'cid')->orderBy('order','ASC');
    }

    public function permissions() {
        return $this->hasMany('Forums\Models\ForumPermission', 'cid', 'cid');
    }

    static function whereHasViewableBoards($auth) {
        if ($auth->check()) {
            $viewable = self::whereHas('boards', function($query) use ($auth) {
                $query->whereIn('bid', ForumUser::find($auth->id())->viewableBoards()->pluck('bid'));
            });
        } else {
            $viewable = self::disableCache()->whereDoesntHave('permissions', function ($query) {
                $query->where(['name' => 'view', 'type' => 'deny'])->where('subject', 'everyone');
            })->orWhereHas('boards', function($query) {
                $query->whereHas('permissions', function($query) {
                    $query->where(['name' => 'view', 'type' => 'allow'])->where('subject', 'everyone');
                });
            });
        }
        return $viewable;
    }
}
