<?php
namespace Forums\Models;

use App\Models\Model;

class ForumBoard extends Model
{
    protected $primaryKey = 'bid';
    public $timestamps = false;
    protected $guarded = [];

    public function permissions() {
        return $this->hasMany('Forums\Models\ForumPermission', 'bid', 'bid');
    }

    public function threads() {
        return $this->hasMany('Forums\Models\ForumThread', 'bid', 'bid');
    }

    public function category() {
        return $this->belongsTo('Forums\Models\ForumCategory', 'cid', 'cid');
    }

    public function getTotalThreadsAttribute() {
        return $this->threads()->count();
    }

    public function latest_thread() {
        return $this->hasOne('Forums\Models\ForumThread', 'bid', 'bid')->orderBy('last_posted','DESC');
    }

    public function getTotalPostsAttribute() {
        return ForumPost::whereIn('tid', $this->threads()->pluck('tid'))->count();
    }

    static function getViewable($auth) {
        if ($auth->check()) {
            $viewable = ForumUser::find($auth->id())->viewableBoards();
        } else {
            $viewable = self::disableCache()->whereIn('cid', ForumCategory::disableCache()->whereDoesntHave('permissions', function ($query) {
                $query->where(['name' => 'view', 'type' => 'deny'])->where('subject', 'everyone');
            })->get()->pluck('cid'))->whereDoesntHave('permissions', function ($query) {
                $query->where(['name' => 'view', 'type' => 'deny'])->where('subject', 'everyone');
            })->orWhereHas('permissions', function ($query) {
                $query->where(['name' => 'view', 'type' => 'allow'])->where('subject', 'everyone');
            })->get();
        }
        return $viewable;
    }
}
