<?php
namespace Forums\Middleware;

use Slim\Routing\RouteContext;
use Forums\Models\ForumThread;
use Forums\Models\ForumPost;

class ThreadUnlockedMiddleware extends \App\Middleware\Middleware
{
    public function __invoke($request, $handler) {
        $params = $request->getParams();
        $args = RouteContext::fromRequest($request)->getRoutingResults()->getRouteArguments();

        if (isset($params['tid'])) { // for reply route
            $thread = ForumThread::find($params['tid']);
        } else if (isset($params['pid'])) { // for react & edit routes
            $thread = ForumPost::find($params['pid'])->thread;
        } else {
            $thread = ForumThread::find($args['tid']);
        }

        if ($thread->locked) {
            throw new \Slim\Exception\HttpForbiddenException($request);
        }

        return $handler->handle($request);
    }
}
