<?php
namespace Forums\Middleware;

use Slim\Routing\RouteContext;
use Forums\Models\ForumThread;
use Forums\Models\ForumBoard;

class CanViewMiddleware extends \App\Middleware\Middleware
{
    public function __invoke($request, $handler) {
        $args = RouteContext::fromRequest($request)->getRoutingResults()->getRouteArguments();

        if (isset($args['tid'])) { // for thread view
            $bid = ForumThread::where('tid',$args['tid'])->first()->bid;
        } else { // for board & create views
            $bid = $args['bid'];
        }

        $viewable = ForumBoard::getViewable($this->container->auth);
        if (!$viewable->pluck('bid')->contains($bid)) {
            throw new \Slim\Exception\HttpForbiddenException($request);
        }

        return $handler->handle($request);
    }
}
