<?php
namespace Forums\Middleware;

use Forums\Models\ForumUser;
use Forums\Models\ForumThread;

class CanModerateMiddleware extends \App\Middleware\Middleware
{
    public function __invoke($request, $handler) {
        if (!ForumUser::find($this->container->auth->user()->steamid)->canModerate(ForumThread::find($request->getParam('tid')))) {
            throw new \Slim\Exception\HttpForbiddenException($request);
        }

        return $handler->handle($request);
    }
}
