<?php
namespace Forums\Listeners;

use Forums\Events\ForumPostCreated as Event;
use App\Models\User;

class ForumPostCreated
{
    public function handle(Event $event) {
        $post = $event->forumPost;
        $notifiedUsers = [];

        preg_match_all('/\[.*?\]\(\/users\/([0-9]+)\)/', $post->content, $matches);
        foreach ($matches[1] as $userId) {
            if (!in_array($userId, $notifiedUsers)) {
                array_push($notifiedUsers, $userId);
                User::find($userId)->notifications()->create([
                    'type' => 'forums_mention',
                    'json' => [
                        'ref_user_id' => $post->user->id,
                        'tid' => $post->tid,
                        'pid' => $post->pid,
                        'page' => $post->page
                    ]
                ])->flushCache();
            }
        }

        if ($post->quotedPost) {
            $quotedUser = $post->quotedPost->user;
            if (!in_array($quotedUser->id, $notifiedUsers)) {
                $quotedUser->notifications()->create([
                    'type' => 'forums_quote',
                    'json' => [
                        'ref_user_id' => $post->user->id,
                        'tid' => $post->tid,
                        'pid' => $post->pid,
                        'page' => $post->page
                    ]
                ])->flushCache();
            }
        }
    }
}
