<?php
namespace Forums\Controllers;

use App\Controllers\Controller;
use Slim\Views\Twig as View;
use Slim\Routing\RouteContext;
use App\Models\Role;
use App\Models\Setting;
use Forums\Models\ForumCategory;
use Forums\Models\ForumBoard;
use Forums\Models\ForumPost;

class ForumsPageController extends Controller
{
    public function admin($request, $response) {
        $this->view->getEnvironment()->addGlobal('settings', Setting::getByCategory('forums')->toJson(JSON_FORCE_OBJECT));
        $categories = ForumCategory::orderBy('cid','asc')->with('boards')->get();
        $this->view->getEnvironment()->addGlobal('categories', $categories->toJson());
        $this->view->getEnvironment()->addGlobal('roles', Role::getExtended()->toJson());
        return $this->view->render($response, 'admin/forums.twig');
    }

    public function spa($request, $response) {
        $this->view->getEnvironment()->addGlobal('boards', ForumBoard::getViewable($this->auth));
        return $this->view->render($response, 'forumsspa.twig');
    }

    public function post($request, $response, $args) {
        $perPage = 15;
        $post = ForumPost::find($args['pid']);
        if ($post == null) {
            throw new \Slim\Exception\HttpNotFoundException($request);
        }
        $thread = $post->thread;

        $postIndex = 1;
        foreach ($thread->posts as $post) {
            if ($args['pid'] == $post->pid) {
                $page = ceil($postIndex/$perPage);
                break;
            }
            $postIndex++;
        }

        return $response->withRedirect(RouteContext::fromRequest($request)->getRouteParser()->urlFor('thread', [
            'tid' => $thread->tid,
            'page' => $page
        ]).'#post-'.$args['pid']);
    }
}
