<?php
namespace Forums\Controllers;

use App\Controllers\Controller;
use Forums\Models\ForumCategory;
use Forums\Models\ForumBoard;
use Forums\Models\ForumPermission;
use Forums\Models\ForumThread;

class ForumsAdminController extends Controller
{
    public function postCategory($request, $response, $args) {
        $params = $request->getParams();
        ForumCategory::updateOrCreate(['cid'=>$params['cid']],['name'=>$params['name']])->flushCache();
        return $response->withJSON(['status'=>'success']);
    }
    public function deleteCategory($request, $response, $args) {
        $params = $request->getParams();
        $category = ForumCategory::where('cid',$params['cid'])->first();
        if ($category->boards->count() > 0) {
            return $response->withJSON(['status'=>'error_category_contains_boards']);
        } else {
            $category->delete();
            return $response->withJSON(['status'=>'success']);
        }
    }

    public function postBoard($request, $response, $args) {
        $params = $request->getParams();
        ForumBoard::updateOrCreate(
          ['bid'=>$params['bid'],'cid'=>$params['cid']],
          [$params['field']=>!empty($params['value']) ? $params['value'] : null]
        )->flushCache();
        return $response->withJSON(['status'=>'success']);
    }
    public function deleteBoard($request, $response, $args) {
        $params = $request->getParams();
        $board = ForumBoard::where('bid',$params['bid'])->first();
        if ($board->threads->count() > 0) {
            return $response->withJSON(['status'=>'error_board_contains_threads']);
        } else {
            $board->delete();
            return $response->withJSON(['status'=>'success']);
        }
    }

    public function postUpdateBoardPositions($request, $response, $args) {
        $params = $request->getParams();
        foreach ($params['boardOrders'] as $bO) {
            ForumBoard::find($bO['bid'])->update(['cid'=>$bO['cid'],'order'=>$bO['order']]);
        }
        return $response->withJSON(['status'=>'success']);
    }

    public function getPermissions($request, $response, $args) {
        $params = $request->getParams();
        if (!in_array($params['idCol'], ['cid', 'bid'])) { return $response->withStatus(422); }

        $permissions = ForumPermission::where($params['idCol'], $params['id'])->where('subject', 'role');

        $permissions = $permissions->get()
                        ->groupBy('rid')
                        ->map(function ($rolePerms) { return $rolePerms->keyBy('name'); });

        $permissions->put(0, ForumPermission::where($params['idCol'], $params['id'])->where('subject', 'everyone')->get()->keyBy('name'))
                    ->put(-1, ForumPermission::where($params['idCol'], $params['id'])->where('subject', 'banned')->get()->keyBy('name'));

        return $response->withJSON(['status'=>'success', 'permissions'=>$permissions]);
    }

    public function postPermissions($request, $response, $args) {
        $params = $request->getParams();
        if (!in_array($params['idCol'], ['cid', 'bid'])) { return $response->withStatus(422); }

        $subject = $params['subject'] ?? 'role';

        $permission = null;

        if ($params['type'] == 'inherit') {
            ForumPermission::where($params['idCol'], $params['id'])->where('subject', $subject)->where('name', $params['name'])->where('rid', $params['rid'])->delete();
        } else {
            $permission = ForumPermission::updateOrCreate(
                [
                    $params['idCol'] => $params['id'],
                    'subject' => $subject,
                    'name' => $params['name'],
                    'rid' => $params['rid']
                ],
                ['type' => $params['type']
            ]);
        }

        return $response->withJSON(['status'=>'success', 'permission'=>$permission]);
    }
}
