<?php

return [
    [
        'version' => '1.0.8',
        'sql' => 'ALTER TABLE `forum_boards`
                    CHANGE COLUMN `name` `name` VARCHAR(50) NULL DEFAULT NULL AFTER `cid`;
                ALTER TABLE `forum_categories`
                    CHANGE COLUMN `name` `name` VARCHAR(50) NULL DEFAULT NULL AFTER `cid`;'
    ], [
        'version' => '2.0.9',
        'sql' => 'DELETE FROM `forum_threads` WHERE `tid` NOT IN (SELECT `tid` FROM `forum_posts`);'
    ], [
        'version' => '2.1.1',
        'recreate_tables' => true,
        'sql' => "/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;

                INSERT INTO `forum_permissions` (`name`, `subject`, `rid`, `type`, `cid`, `bid`)
                    SELECT 'view', 'role', `gid`, CASE `cannot_view` WHEN 1 THEN 'deny' ELSE 'allow' END, NULL, `bid`
                    FROM `forum_board_permissions`
                    WHERE `cannot_view` IS NOT NULL;

                INSERT INTO `forum_permissions` (`name`, `subject`, `rid`, `type`, `cid`, `bid`)
                    SELECT 'post_thread', 'role', `gid`, CASE `cannot_post_thread` WHEN 1 THEN 'deny' ELSE 'allow' END, NULL, `bid`
                    FROM `forum_board_permissions`
                    WHERE `cannot_post_thread` IS NOT NULL;

                INSERT INTO `forum_permissions` (`name`, `subject`, `rid`, `type`, `cid`, `bid`)
                    SELECT 'post_reply', 'role', `gid`, CASE `cannot_post_reply` WHEN 1 THEN 'deny' ELSE 'allow' END, NULL, `bid`
                    FROM `forum_board_permissions`
                    WHERE `cannot_post_reply` IS NOT NULL;

                INSERT INTO `forum_permissions` (`name`, `subject`, `rid`, `type`, `cid`, `bid`)
                    SELECT 'react', 'role', `gid`, CASE `cannot_react` WHEN 1 THEN 'deny' ELSE 'allow' END, NULL, `bid`
                    FROM `forum_board_permissions`
                    WHERE `cannot_react` IS NOT NULL;

                UPDATE `forum_permissions` SET `rid` = NULL, `subject` = 'everyone' WHERE `rid` = 0;
                UPDATE `forum_permissions` SET `rid` = NULL, `subject` = 'banned' WHERE `rid` = -1;

                DROP TABLE `forum_board_permissions`;

                /*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;" // 171671443
    ], [
        'version' => '2.2.0',
        'sql' => 'ALTER TABLE `forum_threads_read`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL AFTER `tid`,
                    DROP FOREIGN KEY `FK_forum_threads_read_users`,
                    DROP INDEX `steamid, tid`;
                UPDATE `forum_threads_read`
                    INNER JOIN `users` ON `forum_threads_read`.`steamid` = `users`.`steamid`
                    SET `forum_threads_read`.`user_id` = `users`.`id`;
                ALTER TABLE `forum_threads_read`
                    DROP COLUMN `steamid`,
                    ADD UNIQUE INDEX `user_id, tid` (`user_id`, `tid`),
                    ADD CONSTRAINT `FK_forum_threads_read_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE ON DELETE CASCADE;

                ALTER TABLE `forum_posts`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL AFTER `reply_to_pid`,
                    DROP FOREIGN KEY `FK_forum_posts_users`;
                UPDATE `forum_posts`
                    INNER JOIN `users` ON `forum_posts`.`steamid` = `users`.`steamid`
                    SET `forum_posts`.`user_id` = `users`.`id`;
                ALTER TABLE `forum_posts`
                    DROP COLUMN `steamid`,
                    ADD CONSTRAINT `FK_forum_posts_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE ON DELETE CASCADE;

                ALTER TABLE `forum_reactions`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL AFTER `pid`,
                    DROP FOREIGN KEY `FK_forum_reactions_users`;
                UPDATE `forum_reactions`
                    INNER JOIN `users` ON `forum_reactions`.`steamid` = `users`.`steamid`
                    SET `forum_reactions`.`user_id` = `users`.`id`;
                ALTER TABLE `forum_reactions`
                    DROP COLUMN `steamid`,
                    ADD CONSTRAINT `FK_forum_reactions_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE ON DELETE CASCADE;

                ALTER TABLE `forum_threads`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL AFTER `bid`,
                    ADD COLUMN `last_post_user_id` INT UNSIGNED NULL DEFAULT NULL AFTER `last_posted`,
                    DROP FOREIGN KEY `FK_forum_threads_users`,
                    DROP FOREIGN KEY `FK_forum_threads_users_2`;
                UPDATE `forum_threads`
                    INNER JOIN `users` ON `forum_threads`.`steamid` = `users`.`steamid`
                    LEFT JOIN `users` AS `last_post_users` ON `forum_threads`.`last_post_steamid` = `last_post_users`.`steamid`
                    SET `forum_threads`.`user_id` = `users`.`id`, `forum_threads`.`last_post_user_id` = `last_post_users`.`id`;
                ALTER TABLE `forum_threads`
                    DROP COLUMN `steamid`,
                    DROP COLUMN `last_post_steamid`,
                    ADD CONSTRAINT `FK_forum_threads_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE ON DELETE CASCADE,
                    ADD CONSTRAINT `FK_forum_threads_users_2` FOREIGN KEY (`last_post_user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE ON DELETE SET NULL;'
    ],
];
