<?php
use App\Module;

Module::registerModule([
    'name' => 'Forums for Ember',
    'identifier' => 'forums',
    'version' => '2.2.0',
    'description' => 'A fully integrated forum system for Ember.'
]);

$container['view']->getEnvironment()->addGlobal('forums', true);

Module::registerController(Forums\Controllers\ForumsPageController::class, 'ForumsPageController');
Module::registerController(Forums\Controllers\ForumsApiController::class, 'ForumsApiController');
Module::registerController(Forums\Controllers\ForumsAdminController::class, 'ForumsAdminController');

Module::registerEventListener(Forums\Events\ForumPostCreated::class, Forums\Listeners\ForumPostCreated::class);

Module::addNavbarLink([
    'icon' => 'fas fa-comment-alt',
    'name' => 'forums',
    'url' => '/forums'
]);

Module::addNavbarLink([
    'icon' => 'fas fa-comment-alt',
    'name' => 'Forums',
    'url' => '/admin/forums',
    'admin_dropdown' => true
]);
