<?php
use App\Middleware\AdminMiddleware;
use App\Middleware\AuthMiddleware;
use Discord\Middleware\DiscordSyncTokenMiddleware;

$app->get('/admin/discord', 'DiscordController:getSettings')->add(new AdminMiddleware($container));

$app->group('/discord', function($group) use ($container) {
    $group->get('/link/{jwt}', 'DiscordController:getLink');
    $group->get('/linked/{jwt}', 'DiscordController:getLinked')->setName('linked');
})->add(new AuthMiddleware($container));

$app->group('/api/discordroles', function($group) use ($container) {
    $group->put('/{id}', 'DiscordRoleController:update');
    $group->delete('/{id}', 'DiscordRoleController:destroy');
})->add(new AdminMiddleware($container));

$app->group('/api/discord', function($group) use ($container) {
    $group->get('/connectioncheck', 'DiscordController:getConnectionCheck');

    $group->get('/users/{discordid}', 'DiscordController:getUser');
    $group->post('/users/{discordid}/sync', 'UserRoleSyncController:sync');

    $group->post('/roles', 'RoleSyncController:store');
    $group->put('/roles/{roleid}', 'RoleSyncController:update');
    $group->delete('/roles/{roleid}', 'RoleSyncController:destroy');

    $group->post('/users/{discordid}/roles/{roleid}', 'UserRoleSyncController:store');
    $group->delete('/users/{discordid}/roles/{roleid}', 'UserRoleSyncController:destroy');
})->add(new DiscordSyncTokenMiddleware($container));
