<?php
namespace Discord;

use App\Models\Role;
use Discord\Models\DiscordRole;

class Shared
{
    public static function get ($path) {
        global $settings;
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer {$settings['discord']['sync_token']}"]);
            curl_setopt($ch, CURLOPT_URL, "{$settings['discord']['host']}/api/{$path}");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 6);
            $response = curl_exec($ch);
            curl_close($ch);
            return json_decode($response);
        } catch(Exception $e) {

        }
    }

    public static function post ($path, $params) {
        global $settings;
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer {$settings['discord']['sync_token']}"]);
            curl_setopt($ch, CURLOPT_URL, "{$settings['discord']['host']}/api/{$path}");
            $params_str = '';
            $params_str = urldecode(http_build_query($params));
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params_str);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 6);
            $response = curl_exec($ch);
            curl_close($ch);
            return json_decode($response);
        } catch(Exception $e) {

        }
    }

    public static function delete ($path) {
        global $settings;
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer {$settings['discord']['sync_token']}"]);
            curl_setopt($ch, CURLOPT_URL, "{$settings['discord']['host']}/api/{$path}");
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 6);
            curl_exec($ch);
            curl_close($ch);
        } catch(Exception $e) {

        }
    }

    public static function syncRoles ($user) {
        $discordRoles = DiscordRole::whereIn('rid', $user->roles->pluck('rid'))->get();

        $response = Shared::post("users/{$user->discordid}/roles/sync", [
            'roles' => $discordRoles->pluck('discordid')->toArray()
        ]);

        if ($response->status != 'success') return;

        $discordRoles = DiscordRole::whereIn('discordid', $response->roles)->get();
        $userRoles = $user->roles()->get();

        foreach ($discordRoles as $discordRole) {
            if (!$userRoles->contains($discordRole->rid))
                $user->addRole($discordRole->rid);
        }
    }

    /**
     * Create Role and DiscordRole
     * 
     * This method is used when receiving new roles, thus no event should be dispatched upon creation.
     */
    public static function createRoleWithoutEvent($discordid, $name, $color) {
        $color = ($color != '0' ? $color: 'B9BBBE');
        $role = new Role;
        $role::unsetEventDispatcher();
        $role->name = $name;
        $role->color = $color;
        $role->ingame_equivalent = strtolower($name);
        $role->order = Role::count() + 1;
        $role->save();
        $role->flushCache();
        DiscordRole::create(['rid' => $role->rid, 'discordid' => $discordid])->flushCache();
        return $role;
    }
}