<?php
namespace Discord\Middleware;

class DiscordSyncTokenMiddleware extends \App\Middleware\Middleware
{
    public function __invoke($request, $handler) {
        global $settings;
        $authHeader = $request->getHeader('Authorization');
        if (count($authHeader) < 1)
            throw new \Slim\Exception\HttpUnauthorizedException($request);
        $bearerToken = str_replace('Bearer ', '', $authHeader[0]);

        if ($settings['discord']['sync_token'] != $bearerToken) {
            throw new \Slim\Exception\HttpForbiddenException($request);
        }

        return $handler->handle($request);
    }
}
