<?php
namespace Discord\Listeners;

use App\Events\UserSaved as Event;
use App\Models\Setting;
use Discord\Shared;

class UserSaved
{
    public function handle(Event $event) {
        if ($event->user->getOriginal('discordid') == null && $event->user->discordid != null) {
            $rid = Setting::find('discord_linked_assign_rid')->value ?? null;
            if (!empty($rid)) $event->user->addRole($rid);
            Shared::syncRoles($event->user);
        }
    }
}
