<?php
namespace Discord\Listeners;

use App\Events\UserRoleCreated as Event;
use Discord\Shared;
use Discord\Models\DiscordRole;

class UserRoleCreated
{
    public function handle(Event $event)
    {
        if (isset($event->userRole->user->discordid)) {
            $discordid = DiscordRole::where(['rid' => $event->userRole->rid])->first()->discordid ?? null;
            if ($discordid != null)
                Shared::post("users/{$event->userRole->user->discordid}/roles", ['id' => $discordid]);
        }
    }
}
