<?php
namespace Discord\Listeners;

use App\Events\UserRevokedRoleCreated as Event;
use Discord\Shared;
use Discord\Models\DiscordRole;

class UserRevokedRoleCreated
{
    public function handle(Event $event) {
        if (isset($event->userRevokedRole->user->discordid)) {
            $discordRole = DiscordRole::where(['rid' => $event->userRevokedRole->rid])->first();
            if ($discordRole != null)
                Shared::delete("users/{$event->userRevokedRole->user->discordid}/roles/{$discordRole->discordid}");
        }
    }
}
