<?php
namespace Discord\Listeners;

use App\Events\RoleUpdated as Event;
use App\Models\Setting;
use Discord\Shared;
use Discord\Models\DiscordRole;

class RoleUpdated
{
    public function handle(Event $event) {
        if ((Setting::find('discord_roles_sync_updated')->value ?? 0) != 1)
            return;

        $discordRole = DiscordRole::where('rid', $event->role->rid)->first();
        if ($discordRole != null)
            Shared::post("roles/$discordRole->discordid", [
                'name' => urlencode($event->role->name ?? null),
                'color' => urlencode($event->role->color ?? null)
            ]);
    }
}
