<?php
namespace Discord\Listeners;

use App\Events\RoleDeleting as Event;
use App\Models\Setting;
use Discord\Models\DiscordRole;

class RoleDeleting
{
    public function handle(Event $event) {
        DiscordRole::where('rid', $event->role->rid)->delete();

        $setting = Setting::find('discord_linked_assign_rid');
        if ($event->role->rid == $setting->value ?? null)
            $setting->update(['value' => null]);
    }
}
