<?php
namespace Discord\Listeners;

use App\Events\RoleCreated as Event;
use App\Models\Setting;
use Discord\Shared;
use Discord\Models\DiscordRole;

class RoleCreated
{
    public function handle(Event $event) {
        if ((Setting::find('discord_roles_sync_created')->value ?? 0) != 1)
            return;

        $response = Shared::post('roles', [
            'name' => urlencode($event->role->name ?? null),
            'color' => urlencode($event->role->color ?? null)
        ]);

        DiscordRole::create(['rid' => $event->role->rid, 'discordid' => $response->role->id]);
    }
}
