<?php
namespace Discord\Controllers;

use App\Controllers\Controller;
use App\Models\User;
use App\Models\Role;
use Discord\Models\DiscordRole;
use Discord\Shared;

class UserRoleSyncController extends Controller
{
    public function sync($request, $response, $args) {
        $user = User::where(['discordid' => $args['discordid']])->first();
        if ($user) {
            Shared::syncRoles($user);
            return $response->withJSON(['status' => 'success']);
        } else {
            return $response->withJSON(['status' => 'failure', 'message' => 'user_not_found']);
        }
    }

    public function store($request, $response, $args) {
        $user = User::where('discordid', $args['discordid'])->first();
        $discordRole = DiscordRole::where('discordid', $args['roleid'])->first();
        if ($discordRole != null) {
            $role = $discordRole->role;
            $success = $user->addRole($role->rid);
        }
        return $response->withJSON(['status' => $success ? 'success' : 'failure']);
    }

    public function destroy($request, $response, $args) {
        $user = User::where('discordid', $args['discordid'])->first();
        $discordRole = DiscordRole::where('discordid', $args['roleid'])->first();
        if ($user && $discordRole)
            $success = $user->removeRole($discordRole->role->rid);
        return $response->withJSON(['status' => $success ? 'success' : 'failure']);
    }
}
