<?php
namespace Discord\Controllers;

use App\Controllers\Controller;
use App\Models\Setting;
use App\Models\Role;
use Discord\Models\DiscordRole;
use Discord\Shared;

class RoleSyncController extends Controller
{
    public function store($request, $response) {
        if (Setting::find('discord_roles_sync_created')->value != 1 || DiscordRole::where('discordid', $request->getParam('id'))->exists())
            return $response->withJSON(['status' => $success]);

        $color = $request->getParam('color');
        if ($color == '0')
            $color = 'B9BBBE';

        $role = Shared::createRoleWithoutEvent($request->getParam('id'), $request->getParam('name'), $color);

        return $response->withJSON(['status' => $role->exists ? 'success': 'failure']);

    }

    public function update($request, $response, $args) {
        if (Setting::find('discord_roles_sync_updated')->value != 1)
            return $response->withJSON(['status' => $success]);

        $color = $request->getParam('color');
        if ($color == '0')
            $color = 'B9BBBE';

        $discordRole = DiscordRole::where('discordid', $args['roleid'])->first();
        if ($discordRole != null)
            $role = $discordRole->role;
            $role->unsetEventDispatcher(); // don't POST back when receiving changes
            $success = $role->update([
                'name' => $request->getParam('name'),
                'color' => $color
            ]);

        return $response->withJSON(['status' => $success ? 'success': 'failure']);
    }

    public function destroy($request, $response, $args) {
        $success = DiscordRole::where('discordid', $args['roleid'])->delete();
        return $response->withJSON(['status' => $success ? 'success': 'failure']);
    }
}
