<?php
namespace Discord\Controllers;

use App\Controllers\Controller;
use App\Models\Setting;
use App\Models\User;
use App\Models\Role;
use Discord\Models\DiscordRole;
use Discord\Shared;
use Slim\Views\Twig as View;
use Slim\Routing\RouteContext;
use Illuminate\Database\Capsule\Manager as DB;
use Ahc\Jwt\JWT;

class DiscordController extends Controller
{
    public function getSettings($request, $response, $args) {
        $guildRoles = Shared::get('roles');
        $this->view->getEnvironment()->addGlobal('discord_settings', Setting::getByCategory('discord')->toJson(JSON_FORCE_OBJECT));
        $this->view->getEnvironment()->addGlobal('roles', Role::orderBy('order')->get()->toJson());
        $this->view->getEnvironment()->addGlobal('guild_roles', $guildRoles ? json_encode($guildRoles->roles) : '{}');
        $this->view->getEnvironment()->addGlobal('discord_roles', DiscordRole::get()->pluck('discordid', 'rid')->toJson());
        return $this->view->render($response, 'settings.twig');
    }

    public function getConnectionCheck($request, $response, $args) {
        $status = 'bot_unreachable';
        $res = Shared::get('connectioncheck');  
        if ($res && $res->status == 'success') {
            $status = 'success';
        }
        return $response->withJSON(['status' => $status]);
    }

    public function getLink($request, $response, $args) {
        global $settings;
        
        $routeParser = RouteContext::fromRequest($request)->getRouteParser();
        $jwt = new JWT($settings['discord']['sync_token']);
        $payload = $jwt->decode($args['jwt']);

        $user = $this->auth->user();
        if ($user->discordid == null) {
            $user->update(['discordid' => $payload['discordid']]);
            return $response->withRedirect($routeParser->urlFor('linked', ['jwt' => $args['jwt']]));
        } else {
            return $response->withRedirect($routeParser->urlFor('user', ['id' => $user->id]));
        }
    }

    public function getLinked($request, $response, $args) {
        global $settings;
        
        $jwt = new JWT($settings['discord']['sync_token']);
        $payload = $jwt->decode($args['jwt']);

        $this->view->getEnvironment()->addGlobal('discord', [
            'username' => $payload['username'],
            'avatarURL' => $payload['avatarURL']
        ]);

        return $this->view->render($response, 'linked.twig');
    }

    public function getUser($request, $response, $args) {
        $user = User::where('discordid', $args['discordid'])->first();
        return $response->withJSON(['status' => $user ? 'success': 'failure', 'user' => $user]);
    }
}
