<?php
use App\Module;

Module::registerModule([
    'name' => 'Discord integration',
    'identifier' => 'discord',
    'version' => '1.1.5',
    'description' => 'Automatically sync your players\' Ember roles into Discord roles and vice versa. Not endorsed or created by Discord.'
]);

Module::registerController(Discord\Controllers\DiscordController::class, 'DiscordController');
Module::registerController(Discord\Controllers\DiscordRoleController::class, 'DiscordRoleController');
Module::registerController(Discord\Controllers\RoleSyncController::class, 'RoleSyncController');
Module::registerController(Discord\Controllers\UserRoleSyncController::class, 'UserRoleSyncController');

Module::registerEventListener(App\Events\RoleCreated::class, Discord\Listeners\RoleCreated::class);
Module::registerEventListener(App\Events\RoleUpdated::class, Discord\Listeners\RoleUpdated::class);
Module::registerEventListener(App\Events\RoleDeleting::class, Discord\Listeners\RoleDeleting::class);
Module::registerEventListener(App\Events\UserRoleCreated::class, Discord\Listeners\UserRoleCreated::class);
Module::registerEventListener(App\Events\UserRevokedRoleCreated::class, Discord\Listeners\UserRevokedRoleCreated::class);
Module::registerEventListener(App\Events\UserSaved::class, Discord\Listeners\UserSaved::class);

Module::addNavbarLink([
    'icon' => 'fab fa-discord',
    'name' => 'Discord',
    'url' => '/admin/discord',
    'admin_dropdown' => true
]);

require __DIR__ . '/../config.php';
foreach ([
    'DISCORD_HOST' => &$settings['discord']['host'],
    'DISCORD_SYNC_TOKEN' => &$settings['discord']['sync_token']
] as $key => &$value) {
    if (getenv($key)) $value = getenv($key);
}
