import NProgress from 'nprogress';

NProgress.configure({
  showSpinner: false,
  speed: 600
});

window.axios.defaults.onDownloadProgress = e => {
  NProgress.set(Math.floor(e.loaded * 1.0) / e.total);
};

window.axios.interceptors.response.use(res => {
  NProgress.done();
  return res;
}, err => {
  swal({
    type: 'error',
    title: 'Request failed',
    html: `Error requesting <code>${err.config.url}</code>. Status: <code>${err.response.status}</code>.`
  });
  return Promise.reject(err);
});

function updateBodyHeight() {
  var navHeight = document.getElementsByClassName('navbar')[0].offsetHeight;
  document.body.style.marginTop = navHeight + 'px';
  document.body.style.minHeight = Math.max(document.documentElement.clientHeight, window.innerHeight || 0) - navHeight + 'px';
}

updateBodyHeight();
window.addEventListener('load', () => updateBodyHeight());
window.addEventListener('resize', () => updateBodyHeight());
