import Vue from 'vue';
import Quill from 'quill';
import VueQuillEditor from 'vue-quill-editor';
import Mention from 'quill-mention';

window.quillImageHandler = function () {
    var range = this.quill.getSelection();
    Swal.fire({
        title: 'Insert an image',
        input: 'url',
        inputPlaceholder: 'image URL',
        showCancelButton: true,
        inputValidator: (value) => {
            if (value.match(/.(jpg|jpeg|png|gif)/) != null) {
                this.quill.insertEmbed(range.index, 'image', value, Quill.sources.USER);
                this.quill.setSelection(range.index + 1, 0);
            } else {
                return 'A valid image URL is required!';
            }
        }
    })
}

Vue.use(VueQuillEditor, {
    theme: 'snow',
    placeholder: '',
    modules: {
        toolbar: {
            container: [
                [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
                ['bold', 'italic', 'underline'],
                ['link', 'image'],
                [{ 'list': 'ordered' }, { 'list': 'bullet' }, { 'align': [] }],
                ['blockquote', 'code', 'code-block'],
                [{ 'color': [] }, { 'background': [] }],
                ['clean']
            ],
            handlers: {
                image: quillImageHandler
            }
        }
    }
})