import Vue from 'vue';

Vue.directive('click-outside', {
    bind: function (el, binding) {
        el.clickEvent = (event) => {
            if (!(el == event.target || el.contains(event.target)))
                binding.value();
        };
        document.body.addEventListener('click', el.clickEvent);
        el.keyupEvent = (event) => {
            if (event.key === "Escape")
                binding.value();
        };
        document.body.addEventListener('keyup', el.keyupEvent);
    },
    unbind: function (el) {
        document.body.removeEventListener('click', el.clickEvent)
        document.body.removeEventListener('keyup', el.keyupEvent)
    }
});

Vue.directive('tooltip', {
    bind: function (el, binding) {
        el.setAttribute('data-toggle', 'tooltip');

        if (binding.value)
            el.setAttribute('title', binding.value);

        let modifierKeys = Object.keys(binding.modifiers);

        if (modifierKeys.includes('hover'))
            el.setAttribute('data-trigger', 'hover');

        if (modifierKeys.includes('right'))
            el.setAttribute('data-bs-placement', 'right');
        else if (modifierKeys.includes('bottom'))
            el.setAttribute('data-bs-placement', 'bottom');
        else if (modifierKeys.includes('top'))
            el.setAttribute('data-bs-placement', 'top');
        else if (modifierKeys.includes('left'))
            el.setAttribute('data-bs-placement', 'left');

        new bootstrap.Tooltip(el);
    }
});
