window.AOS = require('aos');
AOS.init();

import Vue from 'vue';
window.Vue = Vue;

require('./scripts/directives');

import draggable from 'vuedraggable'
window.draggable = draggable

const files = require.context('./', true, /\.vue$/i)
files.keys().map(key => Vue.component(key.split('/').pop().split('.')[0], files(key).default))

const moment = require('moment')
Vue.use(require('vue-moment'), { moment })
moment.locale(lang['active']);

require('./scripts/bootstrap');
require('./scripts/ui');

Vue.prototype.$http = axios;

Vue.filter('lang', function (value, languageCode = lang['active'], ...replacements) {
  if (!value || Object.keys(lang).length == 0) return ''
  value = value.toString()
  var fallback = lang['en'][value] ? lang['en'][value] : value.charAt(0).toUpperCase() + value.slice(1).replace('_', ' ');
  var str = lang[languageCode][value] ? lang[languageCode][value] : fallback;
  replacements.forEach(s => str = str.replace('%s', s));
  return str;
})

const app = new Vue({
  el: '#app',
  components: {
    draggable
  }
});

require('./scripts/quill');
