var stripe = Stripe(globalThis.store.paymentProcessors.stripe.publishableKey);
var data = { 'type': payment.type };

if (payment.type == 'credits') {
    data.quantity = payment.quantity;
} else if (payment.type == 'package') {
    data.package_id = payment.package.id;
}

axios.post('/store/stripe/session', data).then((res) => {
    stripe.redirectToCheckout({
        sessionId: res.data.session_id.id
    }).then((res) => {
        swal({
            type: 'error',
            title: this.$options.filters.lang('purchase_redirecting_error_title'),
            text: res.error.message,
            confirmButtonText: this.$options.filters.lang('purchase_acknowledge_btn')
        });
    });
});
