<?php
use App\Module;
use App\Store;

Module::registerModule([
    'name' => 'Stripe',
    'identifier' => 'stripe-integration',
    'version' => '1.0.0',
    'description' => 'Stripe store integration.'
]);

Store::registerPaymentProcessor([
    'name' => 'Stripe',
    'identifier' => 'stripe',
    'icon' => 'fab fa-stripe',
    'payment_dashboard_url' => 'https://dashboard.stripe.com/payments/%s',
    'process_script' => file_get_contents(__DIR__ . '/../resources/js/process.js'),
    'settings' => [
        [
            'name' => 'stripe_publishable_key',
            'label' => 'Publishable key',
            'icon' => ['fas', 'fa-eye'],
            'placeholder' => 'pk_test_TYooMQauvdEDq54NiTphI7jx'
        ],
        [
            'name' => 'stripe_secret_key',
            'class' => 'col-12 col-md-5',
            'label' => 'Secret key',
            'icon' => ['fas', 'fa-key'],
            'placeholder' => 'sk_test_4eC39HqLyjWDarjtT1zdp7dc'
        ],
        [
            'name' => 'stripe_webhook_endpoint_url',
            'label' => 'Webhook Endpoint URL <a target="_blank" href="https://dashboard.stripe.com/webhooks">(enter it here)</a>',
            'callback' => 'store/stripe/webhook',
            'icon' => ['fas', 'fa-link']
        ],
        [
            'name' => 'stripe_webhook_signing_secret',
            'label' => 'Webhook Signing secret',
            'icon' => ['fas', 'fa-key'],
            'placeholder' => 'whsec_BOBIaRol4pSKgdbQntP9nGO8zjOi20mb'
        ]
    ]
]);

Module::registerController(StripeIntegration\Controllers\StripeController::class, 'StripeController');
