<?php
use App\Module;
use App\Store;

Module::registerModule([
    'name' => 'PayPal',
    'identifier' => 'paypal-integration',
    'version' => '1.0.0',
    'description' => 'PayPal store integration.'
]);

Store::registerPaymentProcessor([
    'name' => 'PayPal',
    'identifier' => 'paypal',
    'icon' => 'fab fa-paypal',
    'payment_dashboard_url' => 'https://www.paypal.com/cgi-bin/webscr?cmd=_view-a-trans&id=%s',
    'process_script' => file_get_contents(__DIR__ . '/../resources/js/process.js'),
    'settings' => [
        [
            'name' => 'paypal_sandbox_mode',
            'label' => 'Testing mode',
            'icon' => ['fas', 'fa-toolbox'],
            'type' => 'checkbox'
        ],
        [
            'name' => 'paypal_email',
            'label' => 'Email',
            'icon' => ['fas', 'fa-key'],
            'placeholder' => '(for receiving payments)',
            'class' => 'col-12 col-md-5',
        ],
        [
            'name' => 'paypal_ipn_url',
            'label' => 'IPN URL <a target="_blank" href="https://www.paypal.com/cgi-bin/customerprofileweb?cmd=_profile-ipn-notify">(enter it here)</a>',
            'callback' => 'store/paypal/ipn',
            'icon' => ['fas', 'fa-link'],
            'class' => 'col-12 col-md-5'
        ]
    ]
]);

Module::registerController(PaypalIntegration\Controllers\PaypalController::class, 'PaypalController');
