<?php
use App\Module;
use App\Store;

Module::registerModule([
    'name' => 'BitPay',
    'identifier' => 'bitpay-integration',
    'version' => '1.0.0',
    'description' => 'BitPay store integration.'
]);

Store::registerPaymentProcessor([
    'name' => 'BitPay',
    'identifier' => 'bitpay',
    'icon' => 'fab fa-btc',
    'payment_dashboard_url' => 'https://bitpay.com/dashboard/payments/%s',
    'process_script' => file_get_contents(__DIR__ . '/../resources/js/process.js'),
    'settings' => [
        [
            'name' => 'bitpay_test_mode',
            'label' => 'Testing mode',
            'icon' => ['fas', 'fa-toolbox'],
            'type' => 'checkbox'
        ],
        [
            'name' => 'bitpay_api_token',
            'label' => 'API token',
            'icon' => ['fas', 'fa-key'],
            'placeholder' => 'BKh8TJk7eLQDRHtV2no2oRpqU4dYwMTJvbcXnL7zQ8Sr'
        ]
    ]
]);

Module::registerController(BitpayIntegration\Controllers\BitpayController::class, 'BitpayController');
