<?php
$container->instance('modules', []);
$moduleNavbarLinks = [];
$modules = array_filter(glob(__DIR__.'/../modules/*/module'), 'is_dir');

foreach ($modules as $module) {
    preg_match('/modules\/(.*)\/module/', $module, $matches, PREG_OFFSET_CAPTURE);
    $moduleName = $matches[1][0];
    $className = str_replace('-', '', ucwords($moduleName, '-'));
    $loader->setPsr4($className . '\\', $module);
    if (file_exists(__DIR__ . '/../modules/'.$moduleName.'/resources/views')) {
        $container['view']->getLoader()->addPath($module.'/../resources/views');
    }
    if (file_exists(__DIR__ . '/../modules/'.$moduleName.'/bootstrap/module.php')) {
        include __DIR__ . '/../modules/'.$moduleName.'/bootstrap/module.php';
    }
    if (file_exists(__DIR__ . '/../modules/'.$moduleName.'/module/routes.php')) {
        include __DIR__ . '/../modules/'.$moduleName.'/module/routes.php';
    }
}

$container['view']->getEnvironment()->addGlobal('modulenavbarlinks', $moduleNavbarLinks);
