<?php
namespace App;

class Module
{
    static function registerModule($array) {
        global $container;
        $container->extend('modules', function($modules) use ($array) {
            $modules[$array['identifier']] = $array;
            return $modules;
        });
    }

    static function addNavbarLink($link) {
        global $moduleNavbarLinks;
        $moduleNavbarLinks[] = $link;
    }

    static function registerController($class, $name) {
        global $container;
        $container[$name] = function($container) use ($class) {
            return new $class($container);
        };
    }

    static function registerEventListener($event, $listener) {
        global $container;
        $container['dispatcher']->listen($event, $listener);
    }
}
