<?php
namespace App\Models;

class StorePackage extends Model
{
    public $timestamps = false;
    protected $guarded = [];

    public function serverRelation() {
        return $this->hasOne(Server::class, 'id', 'server');
    }

    public function role() {
        return $this->hasOne(Role::class, 'rid', 'rid');
    }

    public function purchases() {
        return $this->hasMany(StorePackagePurchase::class, 'package_id', 'id');
    }

    protected static function interpolateAttributeExpressions(string $string, BaseModel $model) {
        preg_match_all('({(.*?)})', $string, $expressions);
        foreach ($expressions[1] as $expression) {
            $attribute = $model;
            foreach (array_map('trim', explode('.', $expression)) as $subAttribute)
                $attribute = $attribute->$subAttribute ?? null;
            $string = str_replace("{{$expression}}", $attribute, $string);
        }
        return $string;
    }

    public function interpolateCommandExpressions(StorePackagePurchase $purchase) {
        foreach (['commands', 'expiry_commands'] as &$attribute) {
            $commands = $this->{$attribute};
            if (empty($commands)) continue;
            foreach ($commands as &$command)
                $command = self::interpolateAttributeExpressions($command, $purchase);
            $this->{$attribute} = $commands;
        }
    }

    public function getCommandsAttribute($value) {
        return $value ? explode(';', $value): [];
    }

    public function setCommandsAttribute($value) {
        $this->attributes['commands'] = $value ? implode(';', $value): null;
    }

    public function getExpiryCommandsAttribute($value) {
        return $value ? explode(';', $value): [];
    }

    public function setExpiryCommandsAttribute($value) {
        $this->attributes['expiry_commands'] = $value ? implode(';', $value): null;
    }

    public function getPermaWeaponsAttribute($value) {
        return $value ? explode(',', $value): [];
    }

    public function setPermaWeaponsAttribute($value) {
        $this->attributes['perma_weapons'] = $value ? implode(',', $value): null;
    }

    public function getActivePurchasesAttribute() {
        global $container;
        return $this->purchases()->where('user_id', $container->auth->id())->valid()->get();
    }

    public function getPurchaseCountAttribute() {
        global $container;
        return $this->purchases()->where('user_id', $container->auth->id())->count();
    }
}
