<?php
namespace App\Models;

use Kekalainen\GameRQ\SourceQuery;
use Kekalainen\GameRQ\GameSpy4Query;
use Kekalainen\GameRQ\SourceRcon;
use Kekalainen\GameRQ\WebsocketRcon;

class Server extends Model
{
    public $timestamps = false;
    protected $guarded = [];
    protected $hidden = ['token', 'rcon_password', 'rcon_port', 'ban_scope', 'ban_log', 'role_sync', 'role_sync_create', 'poll_interval'];
    protected $casts = ['ban_log' => 'boolean', 'role_sync_create' => 'boolean', 'poll_interval' => 'integer'];

    public function getImageURLAttribute() {
      if (!isset($this->image) && empty($this->image)) {
          if ($this->game === 'gmod') {
              return 'https://steamcdn-a.akamaihd.net/steam/apps/4000/header.jpg';
          } else if ($this->game === 'rust') {
              return 'https://steamcdn-a.akamaihd.net/steam/apps/252490/header.jpg';
          } else if ($this->game === 'csgo') {
              return 'https://steamcdn-a.akamaihd.net/steam/apps/730/header.jpg';
          } else if ($this->game === 'minecraft') {
              return 'https://steam.cryotank.net/wp-content/gallery/minecraft/Minecraft-07-HD.png';
          } else if ($this->game === 'ark') {
              return 'https://steamcdn-a.akamaihd.net/steam/apps/346110/header.jpg';
          } else if ($this->game === 'arma3') {
              return 'https://steamcdn-a.akamaihd.net/steam/apps/107410/header.jpg';
          }
      } else {
          return $this->image;
      }
    }

    public function packages() {
        return $this->hasMany('App\Models\StorePackage', 'server', 'id');
    }

    public static function queryServers($servers) {
        $container = app('container');

        if ($container->cache->has('api_servers')) {
            $infos = $container->cache->get('api_servers');
        } else {
            $infos = [];
            if (!empty($servers)) {
                foreach ($servers as $server) {
                    if (isset($server['address'])) {
                        if ($server['game'] !== "minecraft") {
                            $query = new SourceQuery;
                        } else {
                            $query = new GameSpy4Query;
                        }

                        try {
                            $query->connect($server['address'], $server['query_port']);
                            $infos[$server['id']] = $query->info();
                        } catch (\Exception $e) {
                            $infos[$server['id']] = null;
                        } finally {
                            $query->disconnect();
                        }
                    }
                }
            }

            $container->cache->put('api_servers', $infos ?? null, 120);
        }

        $servers->map(function($server) use ($infos) {
            if (isset($infos[$server->id])) {
                $server['map'] = $infos[$server->id]['map'];
                $server['players'] = $infos[$server->id]['players'];
                $server['maxplayers'] = $infos[$server->id]['maxplayers'];
            }
        });

        return $servers;
    }

    public function rconCommand($command) {
        if ($this->rcon_port == null || $this->rcon_password == null)
            return;
        
        $rcon;
        if ($this->game == 'rust') {
            $rcon = new \Kekalainen\GameRQ\WebsocketRcon;
        } else {
            $rcon = new \Kekalainen\GameRQ\SourceRcon;
        }

        try {
            $rcon->connect($this->address, $this->rcon_port, $this->rcon_password);
            $response = $rcon->command($command);
            return [
                'status' => 'success',
                'message' => $response
            ];
        } catch (\Exception $e) {
            return [
                'status' => 'failure',
                'message' => $e->getMessage()
            ];
        } finally {
            $rcon->disconnect();
        }
    }
}
