<?php
namespace App\Models;

class Role extends Model
{
    protected $primaryKey = 'rid';
    public $timestamps = false;
    protected $guarded = [];
    protected $dispatchesEvents = [
        'created' => \App\Events\RoleCreated::class,
        'updated' => \App\Events\RoleUpdated::class,
        'saving' => \App\Events\RoleSaving::class,
        'deleting' => \App\Events\RoleDeleting::class
    ];
    public $ignoreSavingEvent;

    protected static function boot() {
        parent::boot();
        static::creating(function ($query) {
            $query->order = $query->order ?? Role::count() + 1;
        });
    }

    public function permissions() {
        return $this->hasMany('App\Models\RolePermission', 'rid', 'rid');
    }

    public function excludedServers() {
        return $this->hasMany('App\Models\RoleSyncExcludedServer', 'rid', 'rid');
    }

    public function getColorAttribute($value)
    {
        $color = $value ?? '007BFF';
        return "#$color";
    }

    public function setColorAttribute($value)
    {
        $this->attributes['color'] = str_replace('#','',$value);
    }

    static function getExtended() {
        $roles = Role::orderBy('order','asc')->with(['permissions', 'excludedServers'])->get();

        foreach ($roles as $role) {
            $role->setRelation('permissions', $role->permissions->keyBy('name'));
            $role->setRelation('excludedServers', $role->excludedServers->keyBy('server'));
        }

        $roles->push([
            'rid' => 0,
            'name' => 'Everyone',
            'ingame_equivalent' => 'user',
            'color' => '#ABABAB',
            'icon' => 'fas fa-users',
            'order' => null,
            'permissions' => RolePermission::where('subject', 'everyone')->get()->keyBy('name')
        ])->push([
            'rid' => -1,
            'name' => 'Banned',
            'ingame_equivalent' => 'user',
            'color' => '#FF0000',
            'icon' => 'fas fa-gavel',
            'order' => null,
            'permissions' => RolePermission::where('subject', 'banned')->get()->keyBy('name')
        ]);

        return $roles;
    }
}
