<?php
namespace App\Middleware;

use Slim\Routing\RouteContext;

class UserMatchMiddleware extends Middleware
{
    public function __invoke($request, $handler) {
        $route = RouteContext::fromRequest($request)->getRoute();
        $id = $request->getParam('user_id') ?? $route->getArgument('user_id');

        if ($id != $this->container->auth->id() && !$this->container->auth->isAdmin())
            throw new \Slim\Exception\HttpForbiddenException($request);

        return $handler->handle($request);
    }
}
