<?php
namespace App\Middleware;

class TrailingSlashMiddleware extends Middleware
{
    public function __invoke ($request, $handler) {
        $uri = $request->getUri();
        $path = $uri->getPath();

        if ($path != '/' && substr($path, -1) == '/') {
            $uri = $uri->withPath(substr($path, 0, -1));
            if ($uri->getPort() == 0)
                $uri = $uri->withPort(null);

            if($request->getMethod() == 'GET') {
                return $handler->handle($request)->withHeader('Location', (string) $uri)->withStatus(301);
            } else {
                $request = $request->withUri($uri);
            }
        }

        return $handler->handle($request);
    }
}
