<?php
namespace App\Middleware;

use App\Models\StorePackage;
use App\Models\Setting;
use App\Store;

/**
 * Checks eligibility and adds purchase details to the $request object.
 */
class StorePurchaseMiddleware extends Middleware
{
    public function __invoke($request, $handler) {
        $params = $request->getParams();
        $settings = Setting::getByCategory('store');

        if ($params['type'] == 'credits') {
            if (!$settings['credits_purchase_enabled'] || ($params['quantity'] < $settings['minimum_purchase']))
                return $this->container->response->withStatus(422);

            $request = $request->withAttribute('total', $params['quantity']);
        } else if ($params['type'] == 'package') {
            $package = StorePackage::find($params['package_id'] ?? null);

            if ($package == null)
                return $this->container->response->withStatus(422);

            $request = $request->withAttribute('package', $package);
            $request = $request->withAttribute('total', $package->cost_currency);

            if (Store::purchaseLimitReached($this->container->auth->user(), $package))
                return $this->container->response->withStatus(403)->withJSON(['status' => 'purchase_limit_reached']);
        } else {
            return $this->container->response->withStatus(422);
        }

        return $handler->handle($request);
    }
}
