<?php
namespace App\Middleware;

use App\Models\Server;

class ServerTokenMiddleware extends Middleware
{
    public function __invoke($request, $handler) {
        $authHeader = $request->getHeader('Authorization');
        if (count($authHeader) < 1)
            throw new \Slim\Exception\HttpUnauthorizedException($request);
        $bearerToken = str_replace('Bearer ', '', $authHeader[0]);
        $server = Server::where('token', $bearerToken);

        if (!$server->exists()) {
            throw new \Slim\Exception\HttpForbiddenException($request);
        } else {
            $request = $request->withAttribute('server', $server->first());
        }

        return $handler->handle($request);
    }
}
