<?php
namespace App\Middleware;

use App\Controllers\MigrationController;
use \Slim\Routing\RouteContext;

class MigrationMiddleware extends Middleware
{
    public function __invoke($request, $handler) {
        if (file_exists(__DIR__ . '/../ember.lock')) {
            $routeContext = RouteContext::fromRequest($request);
            $routeName = $routeContext->getRoute()->getName();

            if ($routeName != 'dependencycheck' && $routeName != 'migrate')
                return $this->container->response->withHeader('Location', $routeContext->getRouteParser()->urlFor('dependencycheck'))->withStatus(302);
        }

        return $handler->handle($request);
    }
}
