<?php
namespace App\Middleware;

use \Slim\Routing\RouteContext;

class GuestMiddleware extends Middleware
{
    public function __invoke($request, $handler) {
        if ($this->container->auth->check()) {
            return $this->container->response->withHeader('Location', RouteContext::fromRequest($request)->getRouteParser()->urlFor('landing'))->withStatus(302);
        }

        return $handler->handle($request);
    }
}
