<?php
namespace App\Listeners;

use App\Events\StorePackagePurchaseCreated as Event;

class StorePackagePurchaseCreated
{
    public function handle(Event $event) {
        $purchase = $event->storePackagePurchase;
        $package = $purchase->storePackage;
        $server = $package->serverRelation;
        if ($server->rcon_port != null && $server->rcon_password != null) {
            if ($package->role != null) {
                if ($server->game == 'rust') {
                    $server->rconCommand("oxide.usergroup add {$purchase->user->steamid} {$package->role}");
                } else if ($server->game == 'gmod') {
                    $server->rconCommand("ember_setusergroup {$purchase->user->steamid} {$package->role}");
                }
            }
        }
    }
}
