<?php
namespace App\Listeners;

use App\Events\BanCreated as Event;

class BanCreated
{
    public function handle(Event $event) {
        $ban = $event->ban;
        if ($ban->server != null) {
            if ($ban->server->rcon_port != null && $ban->server->rcon_password != null) {
                if ($ban->server->game == 'rust') {
                    $ban->server->rconCommand("kick {$ban->offender->steamid} \"{$ban->reason}\"");
                } else if ($ban->server->game == 'gmod') {
                    $ban->server->rconCommand("ember_kick {$ban->offender->steamid} \"{$ban->reason}\"");
                } else if ($ban->server->game == 'minecraft') {
                    $ban->server->rconCommand("kick {$ban->offender->minecraft_uuid} \"{$ban->reason}\"");
                }
            }
        }
    }
}
