<?php
namespace App\Controllers;

use App\Models\User;
use App\Models\Setting;

class UserController extends Controller
{
    public function index($request, $response) {
        $params = $request->getParams();

        if ((Setting::find('user_list_visibility')->value ?? 'public') == 'hidden' && !$this->auth->isAdmin())
            throw new \Slim\Exception\HttpForbiddenException($request);

        $users = User::with('roles', 'group');

        if (!empty($params['name']))
            $users = $users->where('name', 'like', "%{$params['name']}%");

        if (!empty($params['steamid']))
            $users = $users->where('steamid', 'like', "%{$params['steamid']}%");

        if (!empty($params['rid']))
            $users = $users->whereHas('roles', function ($query) use ($params) {
                $query->where('roles.rid', $params['rid']);
            });

        if (in_array($params['orderBy'] ?? null, ['created', 'last_online', 'last_played']))
            $users = $users->orderBy($params['orderBy'],$params['sortOrder'] == 'ASC' ? 'ASC': 'DESC');

        $users = $users->paginate($params['perPage'], ['*'], 'page', $params['targetPage']);
        if (!empty($users)) {
            User::cache($users);
            $users->getCollection()->map->append(['avatar']);
        }

        return $response->withJSON($users);
    }

    public function postRole($request, $response, $args) {
        User::find($args['id'])->addRole($request->getParam('rid'));
        return $response->withJSON(['status' => 'success']);
    }

    public function deleteRole($request, $response, $args) {
        User::find($args['id'])->removeRole($args['rid']);
        return $response->withJSON(['status' => 'success']);
    }
}
