<?php
namespace App\Controllers;

use App\Controllers\ApiResourceController;
use App\Models\Translation;

class TranslationController extends ApiResourceController
{
    public function __construct(\Psr\Container\ContainerInterface $container) {
        parent::__construct($container);
        $this->model = Translation::class;
    }

    public function index($request, $response, $args) {
        return $response->withJSON(['data' => $this->model::where('locale', $args['locale'])->get()->pluck('value', 'key')]);
    }

    public function update($request, $response, $args) {
        $params = $request->getParams();
        foreach ($params as &$param) { if ($param === '') { $param = null; } }
        $this->model::updateOrCreate(['locale' => $args['locale'], 'category' => $args['category'], 'key' => $args['key']], ['value' => $params['value']]);
        $this->cache->forget('lang');
        return $response->withStatus(204);
    }

    public function destroy($request, $response, $args) {
        $this->model::where(['locale' => $args['locale'], 'category' => $args['category'], 'key' => $args['key']])->delete();
        $this->cache->forget('lang');
        return $response->withStatus(204);
    }

    public function lang($request, $response) {
        $this->view; // initialized so that $this->lang can be used
        header_remove('Cache-Control'); header_remove('Pragma'); $cache_sec = 604800; $exp = gmdate("D, d M Y H:i:s", time() + $cache_sec) . " GMT";
        $body = $response->getBody();
        $body->write('globalThis.lang = ' . json_encode($this->lang) . ';');
        return $response->withBody($body)->withHeader('Content-Type', 'application/javascript')->withHeader('Cache-Control', "public, max-age=$cache_sec")->withHeader('Expires', $exp);
    }
}
