<?php
namespace App\Controllers;

use App\Controllers\Controller;
use App\Models\StorePackage;

class StorePackageController extends ApiResourceController
{
    public function __construct() {
        $this->model = StorePackage::class;
        $this->columns = [
            'id', 'server', 'name', 'cost_credits', 'cost_currency', 'valid_for', 'purchase_limit',
            'rid', 'darkrpmoney', 'pspoints', 'ps2points', 'ps2premiumpoints', 'perma_weapons', 'lua', 'expiry_lua', 'commands', 'expiry_commands',
            'image', 'description', 'short_description', 'order'
        ];
    }

    public function index($request, $response, $args) {
        $data = StorePackage::orderBy('order','asc');

        $server = $request->getParam('server');
        if ($server) {
            $data = $data->where('server', $server);
        }

        return $response->withJSON(['data' => $data->get()]);
    }

    public function destroy($request, $response, $args) {
        StorePackage::find($args['id'])->serverRelation->flushCache();
        StorePackage::destroy($args['id']);
        return $response->withStatus(204);
    }
}
